/****************************************************************************

    SDIFRAME.CPP       Version 2.00 / January 1996


    Module containing code for the application main SDI frame window

****************************************************************************/



// Include files
#include "stdafx.h"          // Pre-compiled header

#include "sdiframe.h"        // Application main window
#include "resource.h"        // Resource IDs
#include "dialogs.h"         // Dialog definitions

#include "ctl3d.h"           // 3d controls
#include "mfclib.h"          // 3d controls

#include "splchk1.h"      // SpellChecker API



/****************************************************************************

    METHOD:      CMainFrame()

    PURPOSE:     Constructor method for the application main window


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

CMainFrame::CMainFrame() {

    CRect tlRect = rectDefault;


    // Load the accelerator table

    LoadAccelTable("Accelerators");


    // Create the main application window

    tlRect.top    = GetPrivateProfileInt("Window", "Top", tlRect.top, AfxGetApp()->m_pszProfileName);
    tlRect.left   = GetPrivateProfileInt("Window", "Left", tlRect.left, AfxGetApp()->m_pszProfileName);
    tlRect.bottom = GetPrivateProfileInt("Window", "Bottom", tlRect.bottom, AfxGetApp()->m_pszProfileName);
    tlRect.right  = GetPrivateProfileInt("Window", "Right", tlRect.right, AfxGetApp()->m_pszProfileName);

    Create(NULL, AfxGetApp()->m_pszAppName,
           WS_OVERLAPPEDWINDOW,
           tlRect, NULL, NULL);    //"ApplicationMenu");
}





/****************************************************************************

    METHOD:      OnCreate()

    PURPOSE:     Called when the application main window is created


    PARAMETERS:  None

    RETURNS:     int   0

****************************************************************************/

int CMainFrame::OnCreate(LPCREATESTRUCT lpspCreateStruct) { 

    RECT slRect;
    
    
    memset(&slRect, 0, sizeof(RECT));
    
    
    // Set up the application menu

    ptmMenuInit = new CMenu();
    ptmMenuInit->LoadMenu("ApplicationMenu");
    this->SetMenu(ptmMenuInit);


    // Sort out the window caption
    
    this->OnInitMenu();
    
    
    // Create an edit field in the main application window

    tmEdit.Create(WS_CHILD | WS_VISIBLE | WS_TABSTOP |
                  ES_MULTILINE | ES_AUTOVSCROLL | ES_NOHIDESEL |
                  WS_VSCROLL, slRect, this, -1);

    return 0;
}





/****************************************************************************

    METHOD:      OnClose()


    PURPOSE:     Provides processing for application when the system menu
                 of the main application window is clicked.
                 If the user selects Cancel, then exiting the program is
                 not allowed

    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnClose() {

    // Check to see if anything has changed first

    if(OnQueryEndSession()) {
        ptmMenuInit->Detach();
        delete ptmMenuInit;
        DestroyWindow();
    }    
}





/****************************************************************************

    METHOD:      OnQueryEndSession()


    PURPOSE:     Ensures a clean tidy up if the user closes down their
                 windows session.

    PARAMETERS:  None

    RETURNS:     TRUE  Can end the session
                 FALSE Cannot end the session

****************************************************************************/

BOOL CMainFrame::OnQueryEndSession() {

    BOOL blExit = TRUE;


    return blExit;
}





/****************************************************************************

    METHOD:      OnSetFocus()


    PURPOSE:     Called when the main window receives the focus. This method
                 actually passes the focus on to the edit field

    PARAMETERS:  Pointer to the window loosing focus - not used

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnSetFocus(CWnd* ptpOldWnd) {

    tmEdit.SetFocus();
}





/****************************************************************************

    METHOD:      OnSize()


    PURPOSE:     Provides processing for application when the size of the
                 main application window is changed

    PARAMETERS:  Type
                 Width of window
                 Height of window

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnSize(UINT ipType, int ipCx, int ipCy) {

    RECT slClient;


    CFrameWnd::OnSize(ipType, ipCx, ipCy);
    

    tmEdit.MoveWindow(-1, -1,
                      ipCx + 2, ipCy,
                      TRUE);                          


    // Now save the position/size to the .INI file

    if(!this->IsIconic()) {

        if(ipType == SIZE_MAXIMIZED) {

            AfxGetApp()->WriteProfileInt("Window", "Maximise", SW_SHOWMAXIMIZED);

        } else {
            this->GetWindowRect(&slClient);

            AfxGetApp()->WriteProfileInt("Window", "Top", slClient.top);
            AfxGetApp()->WriteProfileInt("Window", "Left", slClient.left);
            AfxGetApp()->WriteProfileInt("Window", "Bottom", slClient.bottom);
            AfxGetApp()->WriteProfileInt("Window", "Right", slClient.right);

            AfxGetApp()->WriteProfileInt("Window", "Maximise", SW_SHOW);
        }
    }
}





/****************************************************************************

    METHOD:      OnMove()


    PURPOSE:     Called when the main window is moved.

    PARAMETERS:  int         New X coordinate of top left of window
                 int         New Y coordinate of the top of the window

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnMove(int ipX, int ipY) {

    RECT slClient;


    CFrameWnd::OnMove(ipX, ipY);

    if(!this->IsIconic() &&
       !this->IsZoomed()) {
        this->GetWindowRect(&slClient);

        AfxGetApp()->WriteProfileInt("Window", "Top", slClient.top);
        AfxGetApp()->WriteProfileInt("Window", "Left", slClient.left);
        AfxGetApp()->WriteProfileInt("Window", "Bottom", slClient.bottom);
        AfxGetApp()->WriteProfileInt("Window", "Right", slClient.right);

        AfxGetApp()->WriteProfileInt("Window", "Maximise", SW_SHOW);
    }
}





/****************************************************************************

    METHOD:      OnInitMenu()

    PURPOSE:     Performs all of the greying/checking of menu options


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnInitMenu(CMenu* ptpMenu) {

    char      szlText[81];


    // Adjust the application main window caption

    wsprintf((LPSTR)szlText, "%s - %s",
             (LPSTR)AfxGetApp()->m_pszAppName,
             (LPSTR)"[Untitled]");
    SetWindowText((LPSTR)szlText);
}

void CMainFrame::OnInitMenu() {

    this->OnInitMenu(ptmMenuInit);
}





/****************************************************************************

    METHOD:      OnSysColorChange()

    PURPOSE:     Handles system colour change for 3d controls.


    PARAMETERS:  None

    RETURNS:     None


    NOTES:       This method must exist if 3d controls are being used in
                 dialogs otherwise if the user uses Control Panel to change
                 the system colours, this application won't change colours
                 properly

****************************************************************************/

void CMainFrame::OnSysColorChange() {

    CFrameWnd::OnSysColorChange();
    ::Ctl3dColorChange();
}





/****************************************************************************

    METHOD:      OnFileExit()

    PURPOSE:     Menu option handler to exit the application


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnFileExit() {

    OnClose();
}





/****************************************************************************

    METHOD:      OnToolsSpellCheckEdit()

    PURPOSE:     Menu option handler to spell check the edit field


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellEdit() {

    int  ilRc;


    ilRc = SpellLoadDictionary();
    if(!ilRc) ilRc = SpellCheckEdit(this->GetSafeHwnd(),
                                    tmEdit.m_hWnd);

    SpellCheckError(this->GetSafeHwnd(), ilRc);

    SpellUnloadDictionary();
}





/****************************************************************************

    METHOD:      OnToolsSpellBuffer()

    PURPOSE:     Menu option handler to spell check a string buffer


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellBuffer() {

    CBufferDlg tlDlg(this);
    tlDlg.DoModal();
}





/****************************************************************************

    METHOD:      OnToolsSpellFile()

    PURPOSE:     Menu option handler to spell check an ASCII file


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellFile() {

    int  ilRc;
    char szlTFileName[MAXFILENAMELEN + 1],
         szlTQualName[MAXFILENAMELEN + 1];
         

    if(FileDlg(this,
               FD_OPEN,
               "Open",
               "Text Files (*.TXT)|*.TXT|All Files (*.*)|*.*||",
               "TXT",
               OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
               szlTFileName, szlTQualName,
               0)) {
        // User has selected a text file to be spell checked,
        // so start the spell checking process...

        ilRc = SpellLoadDictionary();
        if(!ilRc) ilRc = SpellCheckFile(this->GetSafeHwnd(), szlTQualName);

        SpellCheckError(this->GetSafeHwnd(), ilRc);

        SpellUnloadDictionary();
    }
}




/****************************************************************************

    METHOD:      OnToolsSpellWord()

    PURPOSE:     Menu option handler to spell check a word


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellWord() {

    CWordDlg tlDlg(this);
    tlDlg.DoModal();
}





/****************************************************************************

    METHOD:      OnToolsSpellImport()

    PURPOSE:     Menu option handler to import words into the dictionary


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellImport() {

    int  ilRc;
    char szlTFileName[MAXFILENAMELEN + 1],
         szlTQualName[MAXFILENAMELEN + 1];
         

    if(FileDlg(this,
               FD_OPEN,
               "Import",
               "Text Files (*.TXT)|*.TXT|All Files (*.*)|*.*||",
               "TXT",
               OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
               szlTFileName, szlTQualName,
               0)) {
        // User has selected a text file to be imported

        ilRc = SpellLoadDictionary();
        if(!ilRc) ilRc = SpellImportWords(szlTQualName);

        if(!ilRc) {
            AfxMessageBox("Import completed successfully");
        } else {
            SpellCheckError(this->GetSafeHwnd(), ilRc);
        }

        SpellUnloadDictionary();
    }
}





/****************************************************************************

    METHOD:      OnToolsSpellExport()

    PURPOSE:     Menu option handler to export all words from the dictionary


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellExport() {

    int  ilRc;
    char szlTFileName[MAXFILENAMELEN + 1],
         szlTQualName[MAXFILENAMELEN + 1];
         

    if(FileDlg(this,
               FD_SAVEAS,
               "Import",
               "Text Files (*.TXT)|*.TXT|All Files (*.*)|*.*||",
               "TXT",
               OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST |
               OFN_HIDEREADONLY,
               szlTFileName, szlTQualName,
               0)) {
        // User has selected a text file to be imported

        ilRc = SpellLoadDictionary();
        if(!ilRc) ilRc = SpellExportWords(szlTQualName);

        if(!ilRc) {
            AfxMessageBox("Export completed successfully");
        } else {
            SpellCheckError(this->GetSafeHwnd(), ilRc);
        }

        SpellUnloadDictionary();
    }
}





/****************************************************************************

    METHOD:      OnToolsSpellSetup()

    PURPOSE:     Menu option handler to spell check setup dialog


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellSetup() {

    SpellSetup(this->GetSafeHwnd());
}





/****************************************************************************

    METHOD:      OnToolsSpellAbout()

    PURPOSE:     Menu option handler to spell check SpellChecker about dialog


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

void CMainFrame::OnToolsSpellAbout() {

    SpellAbout(this->GetSafeHwnd());
}





/****************************************************************************

    METHOD:      Message Map

    PURPOSE:     Message map for the application main window


    PARAMETERS:  None

    RETURNS:     None

****************************************************************************/

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)

    ON_WM_CREATE()
    ON_WM_CLOSE()
    ON_WM_QUERYENDSESSION()
    ON_WM_SETFOCUS()
    ON_WM_SIZE()
    ON_WM_MOVE()
    ON_WM_INITMENU()
    ON_WM_SYSCOLORCHANGE()

    ON_COMMAND(IDM_FILEEXIT,         OnFileExit)

    ON_COMMAND(IDM_TOOLSSPELLEDIT,   OnToolsSpellEdit)
    ON_COMMAND(IDM_TOOLSSPELLBUFFER, OnToolsSpellBuffer)
    ON_COMMAND(IDM_TOOLSSPELLFILE,   OnToolsSpellFile)
    ON_COMMAND(IDM_TOOLSSPELLWORD,   OnToolsSpellWord)
    ON_COMMAND(IDM_TOOLSSPELLIMPORT, OnToolsSpellImport)
    ON_COMMAND(IDM_TOOLSSPELLEXPORT, OnToolsSpellExport)
    ON_COMMAND(IDM_TOOLSSPELLSETUP,  OnToolsSpellSetup)
    ON_COMMAND(IDM_TOOLSSPELLABOUT,  OnToolsSpellAbout)

END_MESSAGE_MAP()
